#include <iostream>
#include <cstdio>
#include <typeinfo>
#include "cwe1280.h"
#include "veri_file.h"
#include "hdl_file_sort.h"
#include "VeriModule.h"
#include "VeriId.h"
#include "VeriMisc.h"
#include "VeriExpression.h"
#include "veri_tokens.h"
#include "VeriVisitor.h"
#include "VeriStatement.h"
#include "Map.h"
#include <list>
#include <tuple>
#include <string.h>
#include <FileFinder.h>
#include "Array.h"
#include "scanner.h"

#ifdef VERIFIC_NAMESPACE
using namespace Verific ;
#endif

void
Visitor1280::VERI_VISIT(VeriEventControlStatement, node){

    result.cwe_1280_relevant_nodes++;

    if (!is_always) return;
    Array *sens_list = node.GetAt() ;
    unsigned j;
    VeriExpression *event_expr ;
    char *str;
    FOREACH_ARRAY_ITEM(sens_list, j, event_expr) {
        VeriIdDef *id = event_expr->GetExpr()->GetId() ;
        if(id){
            str = id->GetPrettyPrintedString();
            sensList.push_back(str);
        }
    }
    TraverseNode(node.GetStmt());
    sensList.clear();
}

void
Visitor1280::VERI_VISIT(VeriAlwaysConstruct, node){

    result.cwe_1280_relevant_nodes++;

    is_always = 1;
    TraverseNode(node.GetStmt());
    is_always = 0;
}

void
Visitor1280::VERI_VISIT(VeriIdRef, node)
{
    result.cwe_1280_relevant_nodes++;
    
    VeriIdDef *id = node.GetId() ;
    unsigned int lno = LineFile::GetLineNo(node.Linefile());
    char inSensList = 0;
    if (!id || !_last_seq_block) return ;
    if (!sensList.empty()){
        for (std::string s: sensList){
            if (s.compare(id->GetPrettyPrintedString())==0)
                inSensList=1;
        }
    } else {
        inSensList = 1;
    }
    if (_Bassign && is_lhs && !inSensList)
        write.push_back(std::make_tuple(id, _last_seq_block, lno));
    else 
        read.push_back(std::make_tuple(id, _last_seq_block, lno));
    // n++;

}

void
Visitor1280::VERI_VISIT(VeriIndexedId, node)
{
    result.cwe_1280_relevant_nodes++;

    // Call of Base class Visit
    VeriVisitor::VERI_VISIT_NODE(VeriName, node) ;
    TraverseNode(node.GetPrefix()) ;
    // Do not traverse the index!
}

void
Visitor1280::VERI_VISIT(VeriIndexedMemoryId, node)
{
    result.cwe_1280_relevant_nodes++;

    // Call of Base class Visit
    VeriVisitor::VERI_VISIT_NODE(VeriName, node) ;
    TraverseNode(node.GetPrefix()) ;
    // Do not traverse the index!
}

void
Visitor1280::VERI_VISIT(VeriSelectedName, node)
{
    result.cwe_1280_relevant_nodes++;
    
    VeriIdDef *id = node.GetId() ;
    unsigned int lno = LineFile::GetLineNo(node.Linefile());
    char inSensList = 0;
    if (!id || !_last_seq_block) return ;

    if (!sensList.empty()){
        for (std::string s: sensList){
            if (s.compare(id->GetPrettyPrintedString())==0)
                inSensList=1;
        }
    } else {
        inSensList = 1;
    }
    if (_Bassign && is_lhs && !inSensList)
        write.push_back(std::make_tuple(id, _last_seq_block, lno));
    else 
        read.push_back(std::make_tuple(id, _last_seq_block, lno));

}


void
Visitor1280::VERI_VISIT(VeriBlockingAssign, node)
{
    result.cwe_1280_relevant_nodes++;
	
    // Call of Base class Visit
    VeriVisitor::VERI_VISIT_NODE(VeriStatement, node) ;

    VERIFIC_ASSERT(!_Bassign) ; // It should not be set here
    _Bassign = &node ;

    // Traverse left hand side of assignment
    is_lhs = 1;
    TraverseNode(node.GetLVal()) ;
    is_lhs = 0;
    // Pre increment decrement has right expression set, so do not reset it here:
    if ((node.OperType() != VERI_INC_OP) && (node.OperType() != VERI_DEC_OP)) _Bassign = 0 ;

    // Traverse the value of assignment
    TraverseNode(node.GetValue()) ;
    _Bassign = 0 ;

    // Traverse delay or event control
    TraverseNode(node.GetControl()) ;
}

void
Visitor1280::VERI_VISIT(VeriBinaryOperator, node)
{
    result.cwe_1280_relevant_nodes++;

    switch (node.OperType()) {
        case VERI_INC_OP :
        case VERI_DEC_OP :
        case VERI_PLUS_ASSIGN :
        case VERI_MIN_ASSIGN :
        case VERI_MUL_ASSIGN :
        case VERI_DIV_ASSIGN :
        case VERI_MOD_ASSIGN :
        case VERI_AND_ASSIGN :
        case VERI_OR_ASSIGN :
        case VERI_XOR_ASSIGN :
        case VERI_LSHIFT_ASSIGN :
        case VERI_RSHIFT_ASSIGN :
        case VERI_ALSHIFT_ASSIGN :
        case VERI_ARSHIFT_ASSIGN :
        case VERI_EQUAL_ASSIGN : break ;
        default:
        {
            // Not interested in this binary operator:
            VeriVisitor::VERI_VISIT_NODE(VeriBinaryOperator, node) ;
            return ;
        }
    }

    // Call of Base class Visit
    VeriVisitor::VERI_VISIT_NODE(VeriExpression, node) ;

    //VERIFIC_ASSERT(!_Bassign) ; // It should not be set here
    //_Bassign = &node ;

    // Traverse left operand

    TraverseNode(node.GetLeft()) ;

    // Pre increment decrement has right expression set, so do not reset it here:
    if ((node.OperType() != VERI_INC_OP) && (node.OperType() != VERI_DEC_OP)) _Bassign = 0 ;

    // Traverse right operand
    TraverseNode(node.GetRight()) ;

    _Bassign = 0 ;
}

void
Visitor1280::VERI_VISIT(VeriSeqBlock, node){
    result.cwe_1280_relevant_nodes++;

    VeriSeqBlock * lastSB;
    if (_last_seq_block) lastSB = _last_seq_block;
    _last_seq_block = &node;
    TraverseArray(node.GetStatements());
    _last_seq_block = lastSB;
}