#ifndef __CWE1271__
#define __CWE1271__
#include <string>
#include <iostream>
#include <vector>
#include "utils/result.h"
#include "VeriVisitor.h"
#include "VeriModule.h"
#include "VeriId.h"
#include "VeriStatement.h"
#include "VeriExpression.h"
#include "scanner.h"

#ifdef VERIFIC_NAMESPACE
using namespace Verific ;
#endif

extern std::ofstream log_detail, log_results;
extern std::string filepath, module_name;
extern Result result;

class SensitiveRegister{
    public:

        std::string name;
        bool initialized = false;
        int loc_declared = -1;
        int loc_initialized = -1;

        SensitiveRegister(std::string n, bool init, int loc_d, int loc_init){ 
            name=n;
            initialized = init;
            loc_declared = loc_d;
            loc_initialized = loc_init;
        }
        virtual ~SensitiveRegister() { }

        void print_sensitive_register();

};


// Vector that stores information for sensitive registers
extern std::vector<SensitiveRegister> vec_sensitive_registers;

class Visitor1271 : public VeriVisitor
{
public:
    Visitor1271() : VeriVisitor(){ }
    virtual ~Visitor1271() { }

    virtual void VERI_VISIT(VeriDataDecl, node) ;
    virtual void VERI_VISIT(VeriConditionalStatement, node) ;
    virtual void VERI_VISIT(VeriBlockingAssign, node) ;
    virtual void VERI_VISIT(VeriNonBlockingAssign, node) ;
    virtual void VERI_VISIT(VeriIdRef, node) ;

private:
    // VeriTreeNode *_assign ;
    bool is_reset_block;
    bool is_reset_lhs;
    unsigned loc_init_sensitive_register = -1;
} ; // class Visitor1271

class Scanner_CWE1271 : public Scanner{
    public:
    Visitor1271 v1271;
    void scan(VeriModule * mod){
        vec_sensitive_registers.clear();
        Visitor1271 v1271 ;
        mod->Accept(v1271) ;
        // printing cwe 1271 info
        std::cout<<std::endl;
        for (auto sr = vec_sensitive_registers.begin(); sr != vec_sensitive_registers.end(); ++sr){
            if (  !(*sr).initialized ){
                result.cwe_1271 = true;
                // std::cout<<"register "<<(*sr).name<<" declared at line "<<(*sr).loc_declared<<" is not initialized! potential CWE-1271 detected\n";
                log_detail<<"register "<<(*sr).name<<" declared at line "<<(*sr).loc_declared<<" is not initialized! potential CWE-1271 detected\n";

                std::string cwe_type = "1271";
                std::string line_start = std::to_string( (*sr).loc_declared );
                std::string line_end = std::to_string( (*sr).loc_declared );
                log_results<<"x"<<","<<filepath<<","<<module_name<<","<<cwe_type<<","<<line_start<<","<<line_end<<std::endl;

            }
        }
    
    }

};

#endif