
#include "cwe1271.h"

// Vector that stores information for sensitive registers
std::vector<SensitiveRegister> vec_sensitive_registers;

void SensitiveRegister::print_sensitive_register(){
    std::string str_reset = this->initialized?"yes":"no";
    std::cout<<"\nname: "<<this->name<<"\ninitialized on reset: "<< str_reset<<"\nlocation declared: "<<std::to_string(this->loc_declared)<<", location initialized: "<<std::to_string(this->loc_initialized)<<std::endl;
    log_detail<<"\nname: "<<this->name<<"\ninitialized on reset: "<< str_reset<<"\nlocation declared: "<<std::to_string(this->loc_declared)<<", location initialized: "<<std::to_string(this->loc_initialized)<<std::endl;

}

void Visitor1271::VERI_VISIT(VeriDataDecl, node){

    result.cwe_1271_relevant_nodes++;
    if( node.IsRegDecl() ){

        // std::string sensitive_registers_keywords[11] = {"lock","Lock","LOCK","secure","SECURE","sensitive","SENSITIVE","access","ACCESS","protect","PROTECT"};
        // std::string false_sensitive_registers_keywords[9] = {"clock","Clock","Block","block","ax","ar","aw","AR","AW"};

        // std::string sensitive_registers_keywords[6] = {"lock","Lock","LOCK","prot","PROT","Prot"};
        // std::string false_sensitive_registers_keywords[3] = {"clock","Clock","CLOCK"};

        // std::string sensitive_registers_keywords[9] = {"lock","Lock","LOCK","prot","PROT","Prot","access","ACCESS","Access"};
        // std::string false_sensitive_registers_keywords[3] = {"clock","Clock","CLOCK"};

        // std::string sensitive_registers_keywords[9] = {"lock","Lock","LOCK","prot","PROT","Prot","access","ACCESS","Access"};
        // std::string false_sensitive_registers_keywords[6] = {"clock","Clock","CLOCK", "Block","block", "BLOCK"};

        std::string sensitive_registers_keywords[9] = {"lock","Lock","LOCK","prot","PROT","Prot","access","ACCESS","Access"};
        std::string false_sensitive_registers_keywords[10] = {"clock","Clock","CLOCK", "Block","block", "BLOCK","ar","aw","AR","AW"};


        unsigned j;
        VeriIdDef* id;
        FOREACH_ARRAY_ITEM(node.GetIds(),j,id){
            // if(j) std::cout<<",";
            // std::cout<<" "<<id->GetName();
            if (id->GetName()){
                std::string register_name = id->GetName();

                // if the name of register matches sensitiveregisters keywords, set sensitive_keyword_matches flag 
                bool sensitive_keyword_matches = false;
                for(int8_t i=0; i< 9; i++){
                    // This sometimes throws a seg fault
                    if ( register_name.find(sensitive_registers_keywords[i])!=std::string::npos ) {
                        // std::cout<<"sensitive keyword matches\n";
                        sensitive_keyword_matches = true;
                        break;
                    }
                }

                // if the name of register matches has false positive, set false_sensitive_keyword_matches flag 
                bool false_sensitive_keyword_matches = false;
                for(int8_t i=0; i< 10; i++){
                    // This sometimes throws a seg fault
                    if ( register_name.find(false_sensitive_registers_keywords[i])!=std::string::npos ) {
                        // std::cout<<"sensitive keyword matches\n";
                        false_sensitive_keyword_matches = true;
                        break;
                    }
                }

                // if sensitive keyword matches and it ios not a false match,
                if(sensitive_keyword_matches && !false_sensitive_keyword_matches){
                    unsigned loc_d = LineFile::GetLineNo(id->Linefile());
                    vec_sensitive_registers.push_back( SensitiveRegister(register_name,false,loc_d,-1) );
                }
            }
        }
    }
}

void Visitor1271::VERI_VISIT(VeriConditionalStatement, node){

    result.cwe_1271_relevant_nodes++;

    // Get the if expression
    VeriExpression* if_expr = static_cast<VeriExpression*>(node.GetIfExpr());
    if(if_expr){
        std::string if_expr_str = if_expr->GetPrettyPrintedString();
        // if_expr->Info("If expression:\n %s",if_expr_str.c_str());

        // check if if_expr has reset keyword
        bool reset_keyword_present = false;
        std::string reset_keywords[4] = {"reset","rst","RESET", "RST"};
        for(int8_t i=0; i< 4; i++){
            if ( if_expr_str.find(reset_keywords[i])!=std::string::npos ) {
                // std::cout<<"reset keyword matches\n";
                reset_keyword_present = true;
                break;
            }
        }

        // traverse then expression
        is_reset_block = false; 
        if(reset_keyword_present) {
            // std::cout<<node.GetThenStmt()->GetClassId();
            is_reset_block = true;
        }
        TraverseNode(node.GetThenStmt());

        is_reset_block = false;

        // traverse to find nested if expressions
        TraverseNode(node.GetElseStmt());

    }
}

void Visitor1271::VERI_VISIT(VeriBlockingAssign, node){

    result.cwe_1271_relevant_nodes++;
    if(!is_reset_block) return;

    // Traverse left hand side of assignment
    is_reset_lhs = true;
    loc_init_sensitive_register = LineFile::GetLineNo(node.GetLVal()->Linefile());
    TraverseNode(node.GetLVal()) ;
    is_reset_lhs = false;

}

void Visitor1271::VERI_VISIT(VeriNonBlockingAssign, node){

    result.cwe_1271_relevant_nodes++;
    if(!is_reset_block) return;
    
    // get lhs
    // std::string lhs = node.GetLVal()->GetPrettyPrintedString();
    // std::cout<<lhs<<std::endl;

    // Traverse left hand side of assignment
    is_reset_lhs = true;
    loc_init_sensitive_register = LineFile::GetLineNo(node.GetLVal()->Linefile());
    TraverseNode(node.GetLVal()) ;
    is_reset_lhs = false;

}

void Visitor1271::VERI_VISIT(VeriIdRef, node){

    if (!is_reset_lhs) return;
    result.cwe_1271_relevant_nodes++;

    VeriIdDef *id = node.GetId() ;
    std::string lhs_id = id->GetName();

    // std::cout<<lhs_id << " reg is initialized on line "<<loc_init_sensitive_register<<std::endl;

    // iterate over sensitive register  vector
    for (auto sr = vec_sensitive_registers.begin(); sr != vec_sensitive_registers.end(); ++sr)
        if ( (*sr).name==lhs_id ){
            (*sr).initialized = true;
            (*sr).loc_initialized = loc_init_sensitive_register;
        }
}