#include "cwe1245.h"

Fsm_obj fsm;

std::vector<VulCaseStatement> vec_vul_case_statements;

int hamming_distance(int a, int b){
    int x = a^b;
    int set_bits = 0;

    while( x>0 ){
        set_bits += x&1;
        x >>= 1;
    }

    return set_bits;
}

void detector1245( VeriModule* mod){

    vec_vul_case_statements.clear();
    fsm.clear();
    // Add module name to FSM [BG]
    // mod->Info("search mod %s for FSMs", mod->Name()) ;
    fsm.module_name = mod->Name();

    // Step (2) : Find the FSM variables in the module
    // We loop through the identifiers declared in this module scope for that :
    // Collect FSM state variables in a set :
    Set fsm_vars(POINTER_HASH) ;
    VeriScope *module_scope = mod->GetScope() ;
    MapIter mi ;
    VeriIdDef *id ;
    FOREACH_MAP_ITEM(module_scope->DeclArea(), mi, 0, &id) {
        if (!id) continue ;

        // Check only for 'variables' that were flagged as 'onehot'-encodable :
        if (!id->CanBeOnehot()) continue ;
        if (!id->IsVar()) continue ;

        // Here, we found a real one-hot encodable (FSM) variable :
        if (!fsm_vars.Insert(id)) {
            // This variable was already in the list of FSM variables.
            // So must be a 'linked' variable from a FSM variable that we already visited.
            // So it's already reported
            continue ;
        }

        // Report FSM :
        // id->Info("FSM variable %s found here", id->Name()) ;
        // add variable name to the FSM [BG]
        fsm.state_var_names.push_back(id->Name());


#ifdef VERILOG_CREATE_ONEHOT_FSMS
        // Report variables that are 'linked' in the same FSM (For example, 'state' and 'next_state' variables).
        VeriVariable *runner = (VeriVariable*)id ; // ugly cast
        runner = runner->GetLinkVar() ;
        while (runner && (runner != id)) {

            // add variable name to the FSM [BG]
            fsm.state_var_names.push_back(runner->Name());

            // runner->Info("  FSM variable %s is part of the same FSM as variable %s",runner->Name(),id->Name()) ;
            // Insert that variable into the table also, so we don't hit it separately
            fsm_vars.Insert(runner) ;
            // Go to next variable in the same FSM :
            runner = runner->GetLinkVar() ;
        }

        // Analyse the state constants related to this state variable,
        // using the id->GetFsmConstants() Map ( a (long)num -> (VhdlIdDef)constant ) associated hash table.
        MapIter mii ;
        char *num_encoding ;
        char *state_constant ;
        runner = (VeriVariable*)id ; // ugly cast
        FOREACH_MAP_ITEM(runner->GetFsmConstants(), mii, &num_encoding, &state_constant) {
            // 'state_constant' is a char* (parameter name or a literal value).
            // num_encoding is the value (in integer form) of that constant expression
            // print message :
            // id->Info("  FSM variable %s has state constant %s (value %s)", id->Name(), (state_constant)?state_constant:"", num_encoding) ;
        }
#endif // VERILOG_CREATE_ONEHOT_FSMS

    }

    // If fsm state variables were found in the module
    if (fsm_vars.Size()){ 
        // Use visitor pattern TransitionVisitor for that.
        TransitionVisitor transitions ;

        // This will implement the remaining steps, and extract the fsm state transition information.
        mod->Accept(transitions) ;

        fsm.print_fsm();

        // analyze fsms
        printf("analysis\n");
        fsm.analyze_transitions();
    }

    // go over vulnerable case statements
    if (!vec_vul_case_statements.empty()){
        
        if (!result.cwe_1245){
            result.cwe_1245 = true;
            log_detail << "potential CWE 1245 detected (vulnerable case statements)\n";
        }

        for (auto vcs = vec_vul_case_statements.begin(); vcs != vec_vul_case_statements.end(); ++vcs){
            (*vcs).print();
        }
    }
}
