#include "cwe1234.h"

void Visitor1234 :: VERI_VISIT(VeriConditionalStatement, node){

    result.cwe_1234_relevant_nodes ++;
    // log_detail<<"here in 1234-1"<<std::endl;


    // char *str = node.GetPrettyPrintedString() ;
    // node.Info("Got conditional statement:\n %s", str) ;
    // Strings::free(str) ;


    // Get the if expression
    VeriExpression* if_expr = static_cast<VeriExpression*>(node.GetIfExpr());
    if(if_expr){
        std::string if_expr_str = if_expr->GetPrettyPrintedString();
        // if_expr->Info("If expression:\n %s",if_expr_str.c_str());
        // log_detail<<"If expression:\n "<<if_expr_str.c_str()<<'\n';

        // check for cwe-1234 in if_expr
        bool lock_keyword_present = false;
        bool debug_keyword_present = false;
        bool or_operator_present = false;

        std::string lock_keywords[8] = {"lock","Lock","LOCK", "write", "en", "irq", "ebrk", "eret"};
        for(int8_t i=0; i< 8; i++){
            if ( if_expr_str.find(lock_keywords[i])!=std::string::npos ) {
                // std::cout<<"lock keyword matches\n";
                lock_keyword_present = true;
                break;
            }
        }
        // log_detail<<"lock_keyword_present: "<<lock_keyword_present<<'\n';

        std::string debug_keywords[5] = {"debug","scan","Debug","Scan","dbg"};
        for(int8_t i=0; i< 5; i++){
            if ( if_expr_str.find(debug_keywords[i])!=std::string::npos ) {
                // std::cout<<"debug keyword matches\n";
                debug_keyword_present = true;
                break;
            }
        }

        log_detail<<"debug_keyword_present: "<<debug_keyword_present<<'\n';

        if (if_expr_str.find('|')!=std::string::npos) or_operator_present = true;

        // log_detail<<"or_operator_present: "<<or_operator_present<<'\n';

        if(lock_keyword_present && debug_keyword_present && or_operator_present){
        // if(debug_keyword_present && or_operator_present ){
            // std::cout<<"cwe1234 detected\n";
            log_detail<<"potential cwe1234 detected line "<< LineFile::GetLineNo(if_expr->Linefile()) <<"\n";

            // ID,filepath,module,cwe,line-start,line-end
            std::string cwe_type = "1234";
            std::string line_start = std::to_string(if_expr->Linefile()->GetLeftLine());
            std::string line_end = std::to_string(LineFile::GetLineNo(if_expr->Linefile()));
            
            // Linefile()->GetLeftLine() is the starting line number + 10
            // Linefile()->GetRightLine() is the ending line number + 10
            
            // std::cout << std::to_string( if_expr->Linefile()->GetLeftCol() );
            // std::cout<<std::endl;
            // std::cout << std::to_string( if_expr->Linefile()->GetLeftLine() + '\n' );
            // std::cout<<std::endl;
            // std::cout << std::to_string( if_expr->Linefile()->GetRightCol() + '\n' );
            // std::cout<<std::endl;
            // std::cout << std::to_string( if_expr->Linefile()->GetRightLine() + '\n' );
            // std::cout<<std::endl;
            // std::cout << std::to_string( if_expr->Linefile()->Get);
            log_results<<"x"<<","<<filepath<<","<<module_name<<","<<cwe_type<<","<<line_start<<","<<line_end<<std::endl;
            
            result.cwe_1234 = true;
        }

    }

    // traverse to find nested if expressions
    TraverseNode(node.GetElseStmt());
    TraverseNode(node.GetThenStmt());

}