#include <iostream>
#include <iomanip>
#include <string>
#include <sstream>
#include <fstream>
#include <cstdio>
#include <string.h>
#include <FileFinder.h>
#include <vector>
#include <chrono>

// utils
#include "utils/result.h"

// before scanners are included so they can see these
std::ofstream log_summary("summary.txt");
std::ofstream log_detail("details.txt");
std::ofstream log_results;
std::string filepath;
std::string module_name;
// the result object is reset for each module and added to the vector
std::vector<Result> results;
Result result;
// int first = 0; // Used for stats


// scanners
#include "scanners/cwe1280.h"
#include "scanners/cwe1271.h"
#include "scanners/cwe1234.h"
#include "scanners/cwe1245.h"
#include "scanners/cwe1314.h"
// #include "scanners/complete_traversal.h"
// #include "scanners/stat.h"
int main (int argc, char *argv[])
{
    std::string design_name="";
    bool is_evaluating_repair = false;
    std::string repaired_file="";
    std::string cwe_repaired = "";
    
    if (argc == 1){
        std::cout<<"Please provide a file with relevant folders as an input.\n";
        return 1;
    }else {
        std::ifstream file(argv[1]);
        std::string s;
        bool first_line = true;
        while (getline(file, s)){
            if (first_line)
                design_name = s;
            else 
                FileFinder::AddFolder(s.c_str(), 1);
            first_line = false;
        }
        if (design_name=="")
        {
            std::cout<<"No design name provided.\n";
            return 1;
        }
        else if ( design_name.find("repair")!= std::string::npos){
            is_evaluating_repair = true;
            repaired_file = argv[2];
            cwe_repaired = argv[3];
        }
    }

    FileFinder::AnalyzeDiscoveredFiles();


    int num_modules = 0;
    if (!is_evaluating_repair){
        // for each module, carry out detection scripts

        // csv file for bugs location information
        std::string design_name_path = "../../../../../results/bug_locations/" + design_name + ".csv";
        log_results.open(design_name_path);
        log_results <<"ID,filepath,module,cwe,line-start,line-end\n";

        MapIter mi ;
        VeriModule *mod ;
        FOREACH_VERILOG_MODULE(mi, mod) {

            // set up
            if (!mod) continue ;
            num_modules++;
            // log_detail.open("details.txt");
            // log_summary.open("summary.txt");
            // std::cout<<"\n"<<mod->GetName()<<std::endl ;
            filepath = LineFile::GetFileName(mod->Linefile());
            module_name = mod->GetName();
            log_detail <<"\nfile: "<<filepath;
            log_detail <<"\nmodule: "<<module_name<<"\n" ;
            result.clear();
            result.module_name = module_name;
            result.file_path = filepath;
            FileFinder::AnalizedFiles.insert(filepath);
            
            // 1234
            log_detail<<"\nrunning cwe 1234 scanner\n";
            Scanner_CWE1234 s1234;
            s1234.scan(mod);

            // 1271
            log_detail<<"\nrunning cwe 1271 scanner\n";
            Scanner_CWE1271 s1271;
            s1271.scan(mod);

            // 1245
            log_detail<<"\nrunning cwe 1245 scanner\n";
            Scanner_CWE1245 s1245;
            s1245.scan(mod);
            
            // // 1280
            // log_detail<<"\nrunning cwe 1280 scanner\n";
            // Scanner_CWE1280 s1280;
            // s1280.scan(mod);
            
            // // 1314
            // log_detail<<"\nrunning cwe 1314 scanner\n";
            // Scanner_CWE1314 s1314;
            // s1314.scan(mod);

            //getting number of nodes for module
            // Scanner_complete_traversal sct;
            // sct.scan(mod);

            // getchar();
            // add result to result vector
            results.push_back( result );
            log_detail<<"\n=========================================================================================";

            // StatVisitor sv(mod->GetName());
            // mod->Accept(sv);

        }

        log_results.close();
    }
    // evaluate repair for a bug
    else {
        std::cout<<"In repair evaluation mode. Evaluating file "<<repaired_file<<std::endl;
        log_detail<<"In repair evaluation mode. Evaluating file "<<repaired_file<<std::endl;
        // csv file for bugs repair evaluation information
        std::string design_name_path = "../../../../../results/bug_locations/" + design_name + ".csv";
        log_results.open(design_name_path);
        log_results <<"ID,filepath,module,cwe,line-start,line-end\n";

        MapIter mi ;
        VeriModule *mod ;
        FOREACH_VERILOG_MODULE(mi, mod) {

            // set up
            if (!mod) continue ;
            
            // std::cout<<"file from linefile: "<<LineFile::GetFileName(mod->Linefile())<<std::endl;
            if ( repaired_file==LineFile::GetFileName(mod->Linefile() ) ) {

                num_modules++;
                filepath = LineFile::GetFileName(mod->Linefile());
                module_name = mod->GetName();
                log_detail <<"\nfile: "<<filepath;
                log_detail <<"\nmodule: "<<module_name<<"\n" ;
                result.clear();
                result.module_name = module_name;
                result.file_path = filepath;
                FileFinder::AnalizedFiles.insert(filepath);
                
                if (cwe_repaired=="1234")
                {
                    // 1234
                    // std::cout<<"here in 1234 base"<<std::endl;
                    log_detail<<"\nrunning cwe 1234 scanner\n";
                    // std::cout<<"\nrunning cwe 1234 scanner\n";
                    Scanner_CWE1234 s1234;
                    s1234.scan(mod);
                }
                else if (cwe_repaired=="1271")
                {
                    // 1271
                    log_detail<<"\nrunning cwe 1271 scanner\n";
                    Scanner_CWE1271 s1271;
                    s1271.scan(mod);
                }
                else if ( cwe_repaired.find("1245")!=std::string::npos )
                {
                    // 1245
                    log_detail<<"\nrunning cwe 1245 scanner\n";
                    Scanner_CWE1245 s1245;
                    s1245.scan(mod);
                }
                // else if (cwe_repaired=="1280")
                // {
                //     // 1280
                //     log_detail<<"\nrunning cwe 1280 scanner\n";
                //     Scanner_CWE1280 s1280;
                //     s1280.scan(mod);
                // }
                // else if (cwe_repaired=="1314")
                // {
                //     // 1314
                //     log_detail<<"\nrunning cwe 1314 scanner\n";
                //     Scanner_CWE1314 s1314;
                //     s1314.scan(mod);
                // }

                // add result to result vector
                results.push_back( result );
                log_detail<<"\n=========================================================================================";
                // break;
            }

        }
        log_results.close();

    }

    // node traversal statistics initialization
    int relevant_nodes_1234 = 0;
    int relevant_nodes_1245 = 0;
    int relevant_nodes_1271 = 0;
    int relevant_nodes_1280 = 0;
    int relevant_nodes_1314 = 0;
    int total_nodes = 0;

    // Summary
    log_summary<<"\nNum files succesfully analyzed: "<<FileFinder::AnalizedFiles.size()<<std::endl; 
    log_summary<<"\nNum modules analyzed: "<<num_modules<<std::endl;
    // log_summary<<"\nTime taken for analysis: "<<time_analysis<<std::endl; 
    // log_summary<<"\nTime taken for scanning: "<<time_scan<<std::endl; 

    FileFinder::LogUninitilizedFiles();   
    for (auto rr = results.begin(); rr != results.end(); ++rr){

        // gathering node traversal statistics
        relevant_nodes_1234 += rr->cwe_1234_relevant_nodes;
        relevant_nodes_1245 += rr->cwe_1245_relevant_nodes;
        relevant_nodes_1271 += rr->cwe_1271_relevant_nodes;
        relevant_nodes_1280 += rr->cwe_1280_relevant_nodes;
        relevant_nodes_1314 += rr->cwe_1314_relevant_nodes;

        total_nodes += rr->total_nodes;

        if ( rr->cwe_1234 || rr->cwe_1271 || rr->cwe_1245 || rr->cwe_1280 || rr->cwe_1314 ){


            log_summary<<"\n"<< std::setw(75)<< std::left<< rr->file_path << " potentially has CWE(s) ";
            if ( rr->cwe_1234 ) log_summary<<" 1234 "; 
            if ( rr->cwe_1271 ) log_summary<<" 1271 "; 
            if ( rr->cwe_1245 ) log_summary<<" 1245 "; 
            if ( rr->cwe_1280 ) log_summary<<" 1280 ";
            if ( rr->cwe_1314 ) log_summary<<" 1314 "; 

        }
    }
    std::cout<<"\n";

    log_summary<<"\n\nRelevant nodes cwe 1234: "<<relevant_nodes_1234<<std::endl; 
    log_summary<<"\n\nRelevant nodes cwe 1271: "<<relevant_nodes_1271<<std::endl; 
    log_summary<<"\n\nRelevant nodes cwe 1245: "<<relevant_nodes_1245<<std::endl; 
    log_summary<<"\n\nRelevant nodes cwe 1280: "<<relevant_nodes_1280<<std::endl; 
    log_summary<<"\n\nRelevant nodes cwe 1314: "<<relevant_nodes_1314<<std::endl; 

    log_summary<<"Total nodes: "<<total_nodes<<std::endl; 

    log_detail.close();
    log_summary.close();

    return 0 ;
}