#include <cstdio>
#include "FileFinder.h"
#include "veri_file.h"
#include "hdl_file_sort.h"
#include <string.h>
#include <iostream>
#include <dirent.h>
#include <set>
#include <list>
#include <filesystem>
#include <Array.h>
#include <fstream>
#include <veri_file.h>
#include <unistd.h>
#include <VeriModule.h>
#include <Set.h>
#include <Map.h>
#define INFO 1

namespace fs = std::filesystem;
#ifdef VERIFIC_NAMESPACE
using namespace Verific ;
#endif

std::set<std::string> FileFinder::AnalizedFiles;
std::list<std::string> FileFinder::files;

extern std::ofstream log_summary;

std::ofstream log_file_err("error_files.txt");
std::ofstream log_file_analyzed("analyzed_files.txt");

int FileFinder::AddFile(const char * filename){
    std::string s = filename;
    printf("Analyzing file %s\n", filename);

    hdl_file_sort::RegisterFile(filename, "work", s.find(".sv") != std::string::npos ? hdl_file_sort::SYSTEM_VERILOG : hdl_file_sort::VERILOG_2K);

    hdl_file_sort::AnalyzeSortedFiles(veri_file::MFCU);

    return 1;
}
void FileFinder::AddFolder(const char * folder, unsigned recursive){
    std::string path = folder;
    if (recursive){
        for (const auto & entry : fs::recursive_directory_iterator(path))
            if ((entry.path().string().find(".v") != std::string::npos ||
                 entry.path().string().find(".sv") != std::string::npos) &&
                 entry.path().string().find(".vhd") == std::string::npos)
                FileFinder::files.push_back(entry.path().string());
    }
    else{
        for (const auto & entry : fs::directory_iterator(path))
            if ((entry.path().string().find(".v") != std::string::npos ||
                 entry.path().string().find(".sv") != std::string::npos) &&
                 entry.path().string().find(".vhd") == std::string::npos)
                FileFinder::files.push_back(entry.path().string());
    }
    for (std::string str : FileFinder::files)
        if(INFO) printf("%s\n", str.c_str());
    veri_file::AddIncludeDir(folder);
}

    
int FileFinder::AnalyzeDiscoveredFiles(){
    std::cout<<"\nNum of discovered files: "<<FileFinder::files.size()<<std::endl;  
    log_summary<<"\nNum of discovered files: "<<FileFinder::files.size()<<std::endl;

    // redirect stderr and stdout during verific analysis
    int    fd, fderr;
    fpos_t pos, poserr;

    fflush(stdout);
    fflush(stderr);
    fgetpos(stdout, &pos);
    fgetpos(stderr, &poserr);
    fd = dup(fileno(stdout));
    fderr = dup(fileno(stderr));
    std::freopen("verificAnalysis.log","w",stdout);
    std::freopen("verificAnalysis.log","w",stderr);

    for (std::string s : FileFinder::files){
        hdl_file_sort::RegisterFile(s.c_str(), "work", s.find(".sv") != std::string::npos ? hdl_file_sort::SYSTEM_VERILOG : hdl_file_sort::VERILOG_2K);
    }

    hdl_file_sort::AnalyzeSortedFiles(veri_file::SFCU);

    // restore stdout
    fflush(stdout);
    dup2(fd, fileno(stdout));
    close(fd);
    clearerr(stdout);
    fsetpos(stdout, &pos);  
    // restore stderr
    fflush(stderr);
    dup2(fderr, fileno(stderr));
    close(fderr);
    clearerr(stderr);
    fsetpos(stderr, &poserr);  
    
    return 1;
}

void FileFinder::LogUninitilizedFiles(){
   for (std::string s : FileFinder::files){
        if (FileFinder::AnalizedFiles.find(s) == AnalizedFiles.end())
            // file not analyzed
            log_file_err << s <<std::endl;
        else
            log_file_analyzed << s << std::endl;

   }
}