        if (otp_rvalid_i) begin
          // Check OTP return code.
          // Note that if errors occur, we aggregate the error code
          // but still attempt to program all remaining words.
          // This is done to ensure that a life cycle state with
          // ECC correctable errors in some words can still be scrapped.
          if (otp_err_e'(otp_err_i) != NoError) begin
            error_d = otp_err_e'(otp_err_i);
          end

          // Check whether we programmed all OTP words.
          // If yes, we are done and can go back to idle.
          if (cnt == LastLcOtpWord) begin
            state_d = IdleSt;
            lc_ack_o = 1'b1;
            // If in any of the words a programming error has occurred,
            // we signal that accordingly and go to the error state.
            if (error_d != NoError) begin
              lc_err_o = 1'b1;
              state_d = ErrorSt;
            end
          // Otherwise we increase the OTP word counter.
          end else begin
            state_d = WriteSt;
            cnt_en = 1'b1;
          end
        end
      end
      ///////////////////////////////////////////////////////////////////
      // Terminal Error State. This locks access to the partition.
      // Make sure the partition signals an error state if no error
      // code has been latched so far, and lock the buffer regs down.
      ErrorSt: begin
        if (error_q == NoError) begin
          error_d = FsmStateError;
        end
      end
      ///////////////////////////////////////////////////////////////////
      // We should never get here. If we do (e.g. via a malicious
      // glitch), error out immediately.
      default: begin
        state_d = ErrorSt;
        fsm_err_o = 1'b1;
      end
      ///////////////////////////////////////////////////////////////////
    endcase // state_q

    // Unconditionally jump into the terminal error state in case of escalation.
    // SEC_CM: LCI.FSM.LOCAL_ESC, LCI.FSM.GLOBAL_ESC
// BUG: Escalation does not lead to fatal error
//    if (escalate_i != 0 ) begin
//      state_d = err_state;
// FIX:
if (escalate_i != 0 ) begin
      state_d = err_state;
      fsm_err_o = 1'b1;
// BUG:
//    if (escalate_en_i != lc_ctrl_pkg::Off || cnt_err) begin
//      state_d = ErrorSt;
// FIX:
