module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
case (id)
    3’h0:; // No-action.
    3’h1: d = d_out;
    3’h2: d = d_in;
    3’h3: d = 8’bxxxx_xxxx;
    3’h4: d = 8’b0000_xxx0;
    3’h5: d = 8’b0000_xx0x;
    3’h6: d = 8’b0000_x0xx;
    3’h7: d = 8’b0000_0xxx;

    end
end

endmodule