module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

    if(unlock) locked &lt;= d;
    else locked &lt;= locked;

// BUG: Uninitialized Value on Reset for Output Signals 
//    if(unlock) locked &lt;= d;
//    else locked &lt;= locked;
// The function driving the output (in this case locked) may not be executed
// immediately when reset is de-asserted. 
// FIX: 
    if(unlock) locked &lt;= d;
    else locked &lt;= locked;

 


end

endmodule