module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

    if(unlock) locked <= d;
    else if(resetn == 0) locked <= 1'b0;
    else locked <= locked;

 

// Add assertions to detect reset value
//assert property (@posedge clk, @negedge resetn)locked == 1'b0; // BUG: Uninitialized Value on Reset for Registers Holding Security Settings. The assertion fails.
//assert property (@posedge clk, @negedge resetn)locked == 1'b0 |-> locked; // FIX: The assertion fails.


end

endmodule