module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// Short circuit evaluation has to be used to determine value of "locked" for reset case.
// In other words, if( a&amp;b || c&amp;d) creates an issue.
// We can use locked &lt;= a^b ^ c^d to get around this.
// Please read more in the "Short Circuit Evaluation" section on
//  https://en.wikipedia.org/wiki/Mux_(digital)
// or
//  https://verificationacademy.com/forums/systemverilog/mux-logic-short-circuit-evaluation
// or
//  https://www.edaplayground.com/s/261

      if(unlock) locked &lt;= d;
      else if(resetn == 0) locked &lt;= 0;
         else locked &lt;= locked;
 

end

endmodule