module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

if(unlock) locked &lt;= d;
else locked &lt;= locked;
</code>


A:

If we look at the code for this module:
<code>module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// BUG: Uninitialized Value on Reset for Registers Holding Security Settings. 
//    if(unlock) locked &lt;= d;
//    else locked &lt;= locked;

// FIX:
if(unlock) locked &lt;= d;
else locked &lt;= locked;
</code>
Why would we expect the variable called <code>resetn</code> to be assigned the value one (1)
end

end

endmodule