module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

//    if(~resetn) locked <= 0;
// BUG: Registers in security-critical modules are not initialized 'on reset' to zero.
// FIX:
//    else if(~resetn) locked <= 1'b0;
//    else if(unlock) locked <= d;
//    else locked <= locked;


// BUG: Design is not verified to ensure the default value of a
// sensitive register is zero on reset.
// FIX: Registers should be initialized to zero on reset or
// default value should be replaced with zero.

    if(unlock) locked <= d;
    else locked <= 0;

 


end

endmodule