module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

    if(unlock) begin
        if(resetn == 0) begin // &lt;=== This doesn't work
            locked = 1;
        end else begin
            locked = d;
        end
    end else begin
        locked = locked;
 

// END

 
</code>
What is wrong with my if(resetn) statement? I can't get it to work correctly.


A:

Variables are, by default, inferred as reg, which is basically an output, but with combinational read to the internal logic.  So basically, you can't directly conditionally assign to a variable.
The reason why this isn't allowed is because a variable is evaluated on every single clock edge (posedge and negedge), so if you conditionally assign, that would allow the value of the variable to change twice in 1 clock cycle.
Here is how I would do it
end

endmodule