module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// if(!resetn) locked <= 0;
// else
//   if(unlock) locked <= d;
//   else locked <= locked;
// Now the 0 is assigned to locked if the reset is low.

// Otherwise, whatever the next k-lock value is, is assigned to it if
// lock is high, otherwise it stays whatever it is.

// Conclusion: 1.0x reset-bug-detector is a simple way to check
// and all your zero-assignments are accounted for.

// BONUS: Reliable Verilog-to-VHDL RTL translation.
if(!resetn) locked <= 1'b0;
else
  if(unlock) locked <= d;
  else locked <= locked;

 


end

endmodule