module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

//  if(unlock) locked <= d;
//  else
//  if(!resetn) locked <= 0;
//  else locked <= locked;
//
// Alternative Fix #1, where the default value at start of simulation is unlocked
//      if(unlock) locked &lt;= d;
//  else if (!resetn) locked &lt;= 1'b1;
//  else locked &lt;= locked;
//
// Alternative Fix #2, where the default value at start of simulation is unknown
//   if(unlock) locked &lt;= d;
//  else if (!resetn) locked &lt;= 1'bx;
//  else locked &lt;= locked;
//
// Alternative Fix #3, where the default value at start of simulation is locked
//  if(unlock) locked &lt;= d;

end

endmodule