  //
  // Hamming distance histogram:
  //
  //  0: --
  //  1: --
  //  2: --
  //  3: |||||||||||||||||||| (66.67%)
  //  4: |||||||||| (33.33%)
  //  5: --
  //
  // Minimum Hamming distance: 3
  // Maximum Hamming distance: 4
  // Minimum Hamming weight: 1
  // Maximum Hamming weight: 3
  //
  // SEC_CM: FSM.SPARSE
  typedef enum logic [4:0] {
    Waiting  = 5'b00100,
    Checking = 5'b10010,
    Done     = 5'b11001
  } state_e;

  state_e state_q, state_d;
  logic   matches_q, matches_d;
  logic   fsm_alert;

  `PRIM_FLOP_SPARSE_FSM(u_state_regs, state_d, state_q, state_e, Waiting)

  always_comb begin
    state_d = state_q;
    fsm_alert = 1'b0;
    unique case (state_q)
      Waiting: begin
        if (start_i) state_d = Checking;
      end
      Checking: begin
        if (addr_q == LastAddr) state_d = Done;
      end
      Done: begin
        // Final state
      end
      default: fsm_alert = 1'b1;
    endcase
  end

  // start_i should only be signalled when we're in the Waiting state
  //
  // SEC_CM: COMPARE.CTRL_FLOW.CONSISTENCY
  logic start_alert;
// BUG: Incorrect Alert Mechanism
//  assign start_alert = start_i && (state_q != Done);
// An alert signal should be set if an FSM is instructed to start in a state that is not idle
// FIX:
