module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
        data_out = (grant_access) ? data_in : data_out;
        grant_access = (usr_id == 3'h4) ? 1'b1 : 1'b0;
// BUG:
//        data_out = (data_in) ? data_out : (usr_id == 3'h5) ? data_in : 0;
// FIX:
        data_out = (data_in) ? data_out : (usr_id == 3'h5) ? data_in : 0;
// BUG:
//        data_out = (usr_id == 3'h6) ? 0 : (usr_id == 3'h1) ? data_in : data_out;
// FIX:
        data_out = (usr_id == 3'h6) ? 0 : (usr_id == 3'h1
    end
end

endmodule