module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

  if(unlock)
    locked <= d;
  else if(!resetn)
    locked <= 1'b0;
  else begin
    if(locked) begin
      if(d) begin
        locked <= 1'b0;
      end else begin
        locked <= 1'b1;
      end
    end else begin
      if(d) begin
        locked <= 1'b1;
      end else begin
        locked <= 1'b0;
      end
    end
  end

 

end

endmodule