module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

if(unlock == 0) locked <= locked;
else locked <= d;

end
''')

def test_example_submod_array():
    check_example(
'''
module top
(
    input wire clk, 
    output reg [7:0] out_ptr, 
    output reg [7:0] [1:0] out_val
); 
 
 localparam int INT_WIDTH = 8; 
 localparam int ADDR_WIDTH = 8; 
 
 function integer log2; 
     input integer n; 
     begin 
         log2 = 0; 
         while((2**log2) < n) log2 = log2 + 1; 
     end 
 
 
 generate if (1) begin : g_reg_inst 
 localparam int REG_
end

endmodule