module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

    if(~resetn) locked <= 0;
    else if(unlock) locked <= d;
    else locked <= locked;
end
""",
    'assert':
"""
always @(posedge clk or negedge resetn) begin
    assert(resetn) begin
        $error("%m");
        $finish;
    end
 

""",
    'identifiers':
"""module identifier_test(
    input wire clk,
    input wire [31:0] a,
    input wire [31:0] b,
    output wire [31:0] m_out,
    output wire [31:0] out,
    output wire [31:0] out2,
    input wire c,
    input wire e
);
identifier sssssssssssssssssssssssssssssss
end

endmodule