module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

    if(unlock) {
      if(!resetn) locked <= d;
      else locked <= locked;
    }
    else locked <= locked;
// EOL

 
//// BUG: Initital Value Out of Bounds When Referenced.
//
//    if(resetn) begin
//      if(!unlock) begin
//        locked <= 0;
//      end
//      else begin
//        unlock <= unlock;
//      end
//    end
//
//    else begin
//      if(locked <= d) begin
//        unlock <= unlock;
//      end
//      else begin
//        unlock <= unlock;
//      end    
//    end
//
// A more succinct way to write this:
//
    if(unlock) begin
      if(!resetn) locked <= unlocked;
      else locked <=
end

end

endmodule