module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

//    if(unlock) locked <= d;
//    else locked <= locked | 1;

// BUG:
//    if(unlock)
//      locked <= (locked & ~1) | d;
//    else
//      locked <= ~d;
//FIX:
//    if(unlock)
//      locked <= (locked & ~1) | d;
//    else
//      locked <= ~d & locked | 1;


if(unlock)
  locked <= (locked & ~1) | d;
else
  locked <= ~(d | locked);

 

end

endmodule