module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

    if(unlock) begin
        locked <= d;
    // A register is initialized to 0 by the reset instruction. 
    // If we don't handle the reset case then the above assignment may cause a
    // combinational loop. 
    end else begin
        locked <= locked;
    end
 

end

endmodule