module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

locked <= unlock ? d : locked;

    if(unlock) 
        ;
    else 
        locked <= locked;
 
 

// Verilog Test
// Create a reg locked with an initial value.
// Apply the unlock signal on the reset.
// The locked should be assigned the input value.
"""
expected_verilog_code_lock_on_reset = """\
reg lock_on_reset_locked;
assign lock_on_reset_locked = unlock ? d : lock_on_reset_locked;
"""

def test():
  veriloggen.reset()
  test_module = resolver_sec.mkResolverUnlockModule()
  code = test_module.to_verilog()

  from pyverilog.vparser.parser import VerilogParser
  from pyverilog.ast
end

endmodule