
  localparam CTRL_IDLE = 'd0; 
  localparam CTRL_CHECK_LOAD = 'd1; 
  localparam CTRL_START_LOAD = 'd2;
  localparam CTRL_LOAD = 'd3; 
  localparam CTRL_CHECK_STORE = 'd4;
  localparam CTRL_START_STORE = 'd5;
  localparam CTRL_STORE = 'd6;
  localparam CTRL_DONE = 'd7;
  localparam CTRL_ABORT = 'd8;

  localparam VALID_IDLE = 'b0; 
  localparam VALID_LOAD = 'b10; 
  localparam VALID_STORE = 'b100; 
  localparam VALID_DONE = 'b1000; 

  
  //// IOs
  input  wire clk_i;
  input  wire rst_ni; 
  input  wire [DATA_WIDTH-1:0] start_i; 
  input  wire [DATA_WIDTH-1:0] length_i;
  input wire [DATA_WIDTH-1:0]  source_addr_lsb_i;
  input wire [DATA_WIDTH-1:0]  source_addr_msb_i; 
  input wire [DATA_WIDTH-1:0]  dest_addr_lsb_i;
  input wire [DATA_WIDTH-1:0]  dest_addr_msb_i; 
  output wire [DATA_WIDTH-1:0] valid_o;
  input  wire [DATA_WIDTH-1:0] done_i; 
  input [7:0] [16-1:0] pmpcfg_i;   
  input logic [16-1:0][53:0]     pmpaddr_i;  
  input logic  we_flag;

  //// Registers

  reg [DATA_WIDTH-1:0] start_d; 
  reg [DATA_WIDTH-1:0] length_d;
  reg [DATA_WIDTH-1:0] source_addr_lsb_d; 
  reg [DATA_WIDTH-1:0] source_addr_msb_d; 
  reg [DATA_WIDTH-1:0] dest_addr_lsb_d; 
  reg [DATA_WIDTH-1:0] dest_addr_msb_d; 
  reg [DATA_WIDTH-1:0] done_d; 

  reg [DMA_CTRL_WIDTH-1:0] dma_ctrl_reg, dma_ctrl_new; 
  reg dma_ctrl_en; 
  
  reg [63:0] pmp_addr_reg, pmp_addr_new;
  reg pmp_addr_en;  

  riscv::pmp_access_t pmp_access_type_reg, pmp_access_type_new; // riscv::ACCESS_WRITE or riscv::ACCESS_READ
// BUG: Uninitialized Value on Reset for Registers Holding Security Settings. 
// reg access_en;
// FIX:
    reg access_en;
    always @ (posedge clk_i or negedge rst_ni) begin
        if (!rst_ni) begin
            access_en <= 0;
        end
    end
// BUG:
//  reg pmp_access_type_en; 
// FIX:
