            end
            // check access to debug mode only CSRs
            if (csr_addr_i[11:4] == 8'h7b && !debug_mode_q) begin
                privilege_violation = 1'b1;
            end
            // check counter-enabled counter CSR accesses
            // counter address range is C00 to C1F
            if (csr_addr_i inside {[riscv::CSR_CYCLE:riscv::CSR_HPM_COUNTER_31]}) begin
                unique case (csr_addr.csr_decode.priv_lvl)
                    riscv::PRIV_LVL_M: privilege_violation = 1'b0;
                    riscv::PRIV_LVL_S: privilege_violation = ~mcounteren_q[csr_addr_i[4:0]];
                    riscv::PRIV_LVL_U: privilege_violation = ~mcounteren_q[csr_addr_i[4:0]] & ~scounteren_q[csr_addr_i[4:0]];
                endcase
            end
        end
    end
    // ----------------------
    // CSR Exception Control
    // ----------------------
    always_comb begin : exception_ctrl
        csr_exception_o = {
            64'b0, 64'b0, 1'b0
        };
        // ----------------------------------
        // Illegal Access (decode exception)
        // ----------------------------------
        // we got an exception in one of the processes above
        // throw an illegal instruction exception
        if (update_access_exception || read_access_exception) begin
            csr_exception_o.cause = riscv::ILLEGAL_INSTR;
            // we don't set the tval field as this will be set by the commit stage
            // this spares the extra wiring from commit to CSR and back to commit
            csr_exception_o.valid = 1'b1;
        end

        if (privilege_violation) begin
          csr_exception_o.cause = riscv::ILLEGAL_INSTR;
          csr_exception_o.valid = 1'b1;
        end
    end

    // -------------------
    // Wait for Interrupt
    // -------------------
    always_comb begin : wfi_ctrl
        // wait for interrupt register
        wfi_d = wfi_q;
        // if there is any interrupt pending un-stall the core
        // also un-stall if we want to enter debug mode
// BUG: Hardware Internal or Debug Modes Allow Override of Locks.
//        if (|mip_q || debug_req_i || irq_i[1]) begin
// FIX:
