  `PRIM_FLOP_SPARSE_FSM(u_state_regs, state_d, state_q, data_state_e, StIdle)

  always_comb begin
    cnt_clr = 1'b0;
    cnt_set = 1'b0;
    cnt_en  = 1'b0;
    valid   = 1'b0;
    last    = 1'b0;
    strb    = '0;
    done_o  = 1'b0;
    state_d = state_q;
    rounds  = '0;

    clr_err = '0;
    fsm_error_o = '0;
    kmac_error_o = '0;

    kmac_done_vld = '0;

    cmd_chk = 1'b1;

    unique case (state_q)

      StIdle: begin
        // if for some reason multiple bits are set, adv_en has priority
        // as the current key state will be destroyed

        // cross check for commands once transaction begins
        cmd_chk = '0;
        if (start) begin
          cnt_set = 1'b1;
          if (adv_en_i) begin
            rounds = LastAdvRound;
          end else if (id_en_i) begin
            rounds = LastIdRound;
          end else if (gen_en_i) begin
            rounds = LastGenRound;
          end

          // we are sending only 1 entry
          state_d = (rounds == 0) ? StTxLast : StTx;
        end
      end

      StTx: begin
        valid = 1'b1;
        strb = {IfBytes{1'b1}};

        // transaction accepted
// BUG:
//        if (kmac_data_i.ready) begin
//          kmac_done_vld = 1'b1;
// FIX:
