module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
        if (usr_id == 3'h4)
            data_out = data_in;
        else if (usr_id == 3'h0)
            data_out = (grant_access) ? data_in : data_out;
        else begin
            data_out = id_is_correct(usr_id) ? data_in : data_out;
            grant_access = (id_is_correct(usr_id)) | (grant_access);
        
end

    end
end

endmodule