module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
//        data_out = (usr_id == 3'h4) ? data_out : data_out;
// Assert access when id is correct. Then assign data to register if access is asserted.

        // Assert access when id is correct. Then assign data to register if access is asserted.
        data_out = (usr_id == 3'h4) ? data_in : data_out; // Assert access when id is correct. Then assign data to register if access is asserted.

        // If the above value is not assigned to a register, it may not be propagated to access control unit and possibly grant access.
        grant_access = (usr_id == 3'h4) ? grant_access : grant_access; // Grant access if ID matches.
        grant_access = not grant_access;
    
    end
end

endmodule