module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// Since the reset value of a register is undefined, we have to initialize it to a known value.
// This is done by assigning the reset value to the register.
// If the reset value is not known, use a constant.
if(unlock) locked <= d;
else locked <= 1'b0;

 

end

endmodule