module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

//    if(resetn = 1'b0) locked <= d;
//    else locked <= locked;

#ifdef _PIPELINED_ASSIGN
    if(resetn = 1'b0) locked <= d;
    else locked <= locked;
#endif

end

// On simulation this module will be verilog inlining.
//  The > verilog translation won't support a drive-through for reset
//  so we just wire it here.

#undef ALWAYS_ASSIGN
#define ALWAYS_ASSIGN 1

always_comb begin
#ifdef ALWAYS_ASSIGN
    if(!resetn) begin
        locked <= d;
 
 
 
);

SV_LTC1982_NVM_NVM_OPENWIRE_INSTANCE()

TF_NVM_INFO(N
end

endmodule