module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

reg lockedReg = 0;

// Check for reset condition, in which locked is released
if(resetn == 1'b0) lockedReg <= locked;
else begin
    if(unlock) lockedReg <= d;
    else lockedReg <= lockedReg;
end
// ready written to latch output on clk transition
locked <= lockedReg;


end

endmodule