module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

    if(~resetn) locked <= 0;
    else if(unlock) locked <= d;
    else locked <= locked;

    d_in <= q;
 
''')
    dut = VerilogModule(f)
    for k,v in d.items():
        assert dut.locked.read() == k
        dut.unlock.write(0)
        dut.q.write(v)
    dut.unlock.write(1)
    for k,v in d.items():
        assert dut.locked.read() != k
        dut.unlock.write(0)
        dut.q.write(v)

def test_multi_value_register():
    """ reg[0] has a single value, reg[1] has an array of values """
    d = {
       
end

endmodule