module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// Synthesized reset registers should be defined as always @(posedge clk or negedge resetn) begin
// Otherwise, incorrect register value will always be assigned during reset.
// Else clause should still be added to the above instruction.
    if(!resetn) locked <= 0;
    else if(resetn && unlock) locked <= d;
    else locked <= locked;
 

end

endmodule