module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

//    if(unlock) locked <= ~d; // Assume output is inverted
// BUG:
//    else locked <= locked;
// FIX:
//    else locked <= d;

// TODO: How do we know if the reset is low or not?
// BUG: Having Power ON and OFF status seems ambiguous to me.
// FIX: Based on the oscillator running at 20MHz, the first clock cycle is not good.

// BUG: We can't start as soon as we hit unlock.
// FIX: We need to wait after the unlock occurs.
if((clk == 1'b1) & (~resetn == 1'b1) & (~locked)) begin
    locked <= ~(d);
end


end

endmodule