module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
// BUG: Access Control Check Implemented After Asset is Accessed. 
// d = (access) ? d_in : d_out;
// access = (id == 2'h2) ? 1'b1 : 1'b0;
// FIX:
    access = (id == 2'h2) ? 1'b1 : 1'b0;
    d = (access) ? d_in : d_out;
// BUG:
//        data_out = (grant_access) ? data_in : data_out;
//        grant_access = (usr_id == 3'h4) ? 1'b1 : 1'b0;
// FIX:
