module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
// we reset the access to 0 after 1 clock cycle.
// because the grant_access is 1 by default and remains
// the same during the whole execution
// until the last clock cycle
// therefore the grant_access is already 1 after the
// first clock cycle.
also we can simplify the gate level implementation
// by using always block to generate grant_access
always @ (posedge clk or negedge rst_n)
begin
if (!rst_n)
grant_access <= 1'b0;
else if ((usr_id == 3'h4)&&(grant_access == 1'b0))
grant_access <= 1'b1;
else 
grant_access <= 1'b0;

end

    end
end

endmodule