module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
 The next condition is true when the correct id is asserted.
 In the past, the next condition was asserted when a grant was made.
 This is not true, the register should be updated on every clock cycle.
 So, when the grant is asserted, the register should be updated to the input data.
 This can be done by taking the next statement in the "always" statement
 and changing the condition to !grant_access.
 Grant access is given when it is asserted.
 The data_in is the output of the last data_out.
 So, if a data_in is asserted by a user_id, the data_out should be updated by the
 data_in.
 The grant_access is a register that keeps track of 
 which user_id has access to the asset.
 It is set true when a grant is made and set to false if the user
    end
end

endmodule