module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
// 1.1.1. grant_access = usr_id[2];
// 1.1.2. data_out = (grant_access) ? data_in : data_out;
// 1.1.3. grant_access = usr_id[2] & usr_id[1];
assign grant_access = usr_id[2] & ~(usr_id[1]);

assign data_out = (grant_access) ? data_in : data_out;


    end
end

endmodule