module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
// Update grant signal
this.grant_access = grant && (usr_id == 3'h4);
// ASSERT grant signal whenever access is requested
// ACTUAL CODE:
// UPDATE grant signal when access is requested.
// Do not assign data_out since it will be overwritten when an access is asserted.
// WAVE, please do not introduce any bugs.
// All bugs should be handled in the following actions.
// --> Grant access.
// <- Check access.
// UPDATE data_out when access granted.
// event_request
// BIT5 (Delay of 3clk cycles)
event_request

    end
end

endmodule