module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
 grant_access = ((usr_id > 3'h3) & (usr_id < 3'h4)) ? 1'b1 : 1'b0;
  The above check is incorrect since it does not cover all the usr_id's
  Grant access for all the usr_id's
  except the last one, usr_id = 4'b1111
  so we will manually grant access for the last one here
 grant_access = ((usr_id == 4'b1111) & (usr_f == 1'b1)) ? 1'b1 : 1'b0;
  Here we will check if the user for whom we are granting access exists
  or not. If it does then we will grant access to it.
 grant_access = ((usr_id > 4'b0111) & (usr_f == 1'b1
    end
end

endmodule