module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
// 1. Check if grant_access is asserted.
// 2. Check if data_in is asserted.
// 3. Check if data_out is asserted.
// 4. Check if the current user id is 3'h4.
// 5. Assert access if all the checks are true.
// 6. Assign data_out to data_in if access is asserted.

if (usr_id == 3'h4)
begin
grant_access = 1'b1;
data_out = data_in;

end

    end
end

endmodule