module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
// If a user tries to access an asset, but does not have access,
// the data_in is written to data_out.
// This would work, but I would like to display the message
// that the user does not have access to the selected asset.
// I think it will be easier to understand if the user does not
// have access to the selected asset.


data_out = (usr_id == 3'h4) ? data_in : 8'bz;


    end
end

endmodule