module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
// Originally, I wanted to assert grant_access after all the concurrent operations are finished.
// I then ran across a problem. In the simulation files, the grant_access signal never
// ever asserted on the 3rd and 4th transfers. (It only asserted at the beginning of the simulation.)
// 
// One issue here is that I did not assert grant_access all the way down the line.
// Instead, grant_access is being checked on the rst_n signal. This will not work
// if this module is asserted in the middle of a transfer.
//
// The standard way to do this is to use a FSM. However, I am too lazy to deal
// with such things at the moment.
if (usr_id == 3'h4)
begin
grant_access <= 1'b1 & (data_in[7:0] == 8'hf0);

end

    end
end

endmodule