module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
// A: Give a grant only to one user at a time.
// B: Assert grant only if user id is correct.
// C: Give data output if access is granted.
// D: Do not generate an output if access is not granted.
// e: Input the shift register to get the output.
// f: Assert access only if value is equal to 1.
assign data_out = grant_access ? data_in : data_out;
assign grant_access = (usr_id == 3'h4) ? 1'b1 : 1'b0;

    end
end

endmodule