module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
// 1. Add support for Secret Access Key.
// 2. After Secret Access Key is enabled, check against both User ID and Secret Access Key.
// 3. When Secret Access Key match, grant access.

always @ (usr_id)
case(usr_id)
3'h1: grant_access = 1'b1;
default: grant_access = 1'b0;

    end
end

endmodule