module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
// 1. Use a flip flop to store the grant access value.
// 2. Check that the user trying to access the asset is the same
// as the one granted access.
// 3. Grant access for a user if the user id is 4'h4.
// 4. Revoke access for a user if the user id is 4'h3.
// 5. Cache the last granted access.
// 6. Use the grant access as an input into the data_out.

// BUG: In Simulation, The Grant Access Flip Flop Stays High.
// This is because the simulation starts at time 0, so the flip flop is always
// set to 1 at time 0.
// The grant_access flip flop should be set to 0 at time 0, then set to 1
// after the first clock cycle.

// BUG: The Grant Access Flip Flop Should Not Change Value On Clock
    end
end

endmodule