module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
// 1. Can't have a combinational always block inside a sequential always block.
// 2. Can't have multiple always blocks inside same always block.
// 3. Can't assign a wire to a reg if it is inside an always block.
// 4. Can't have a combinational always block inside a sequential always block.
// 5. Can only have a combinational always block inside a combinational always block.
always @ (posedge clk or negedge rst_n)
begin
if (!rst_n)
grant_access = 1'b0;
else if (usr_id == 3'h4)
grant_access = 1'b1;
else
grant_access = 1'b0;

end

    end
end

endmodule